@ECHO OFF
::    SSSSSSSSSSSSSSS  TTTTTTTTTTTTTTTTTTTTTTT      OOOOOOOOO      PPPPPPPPPPPPPPPPP
::  SS:::::::::::::::S T:::::::::::::::::::::T    OO:::::::::OO    P::::::::::::::::P
:: S:::::SSSSSS::::::S T:::::::::::::::::::::T  OO:::::::::::::OO  P::::::PPPPPP:::::P
:: S:::::S     SSSSSSS T:::::TT:::::::TT:::::T O:::::::OOO:::::::O PP:::::P     P:::::P
:: S:::::S             TTTTTT  T:::::T  TTTTTT O::::::O   O::::::O   P::::P     P:::::P
:: S:::::S                     T:::::T         O:::::O     O:::::O   P::::P     P:::::P
::  S::::SSSS                  T:::::T         O:::::O     O:::::O   P::::PPPPPP:::::P
::   SS::::::SSSSS             T:::::T         O:::::O     O:::::O   P:::::::::::::PP
::     SSS::::::::SS           T:::::T         O:::::O     O:::::O   P::::PPPPPPPPP
::        SSSSSS::::S          T:::::T         O:::::O     O:::::O   P::::P
::             S:::::S         T:::::T         O:::::O     O:::::O   P::::P
::             S:::::S         T:::::T         O::::::O   O::::::O   P::::P
:: SSSSSSS     S:::::S       TT:::::::TT       O:::::::OOO:::::::O PP::::::PP
:: S::::::SSSSSS:::::S       T:::::::::T        OO:::::::::::::OO  P::::::::P
:: S:::::::::::::::SS        T:::::::::T          OO:::::::::OO    P::::::::P
::  SSSSSSSSSSSSSSS          TTTTTTTTTTT            OOOOOOOOO      PPPPPPPPPP
::
:: DO NOT EDIT THIS FILE. THE OFFICIAL GRAPHENEOS INSTALL GUIDE WILL NEVER INSTRUCT YOU
:: TO EDIT THIS FILE. IF YOU ARE FOLLOWING A 3RD PARTY GUIDE YOU SHOULD STOP IMMEDIATELY
:: AND START OVER AND FOLLOW THE OFFICIAL INSTALLATION PROCESS ON THE OFFICIAL WEBSITE.
:: USING THE WEB INSTALLER IS STRONGLY RECOMMENDED https://grapheneos.org/install/web
:: THE CLI INSTALLATION PROCESS SHOULD ONLY BE USED BY USERS WITH SPECIFIC NEEDS.

:: Copyright 2012 The Android Open Source Project
::
:: Licensed under the Apache License, Version 2.0 (the "License");
:: you may not use this file except in compliance with the License.
:: You may obtain a copy of the License at
::
::      http://www.apache.org/licenses/LICENSE-2.0
::
:: Unless required by applicable law or agreed to in writing, software
:: distributed under the License is distributed on an "AS IS" BASIS,
:: WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
:: See the License for the specific language governing permissions and
:: limitations under the License.

PATH=%PATH%;"%SYSTEMROOT%\System32"

where /q fastboot
if %errorlevel% neq 0 (
  echo fastboot not found
  echo Download the latest version at https://developer.android.com/studio/releases/platform-tools.html and add it to the shell PATH
  call:pakExit
)

:: needed for variable operations inside the fastboot version loop
setlocal EnableDelayedExpansion

for /f "tokens=3" %%a in ('fastboot --version ^| find "fastboot version "') do (
  set full_ver_str=%%a
:: substring first 6 chars
  set ver_str=!full_ver_str:~0,6!
:: remove dots
  set ver_num=!ver_str:.=!
  if not !ver_num! geq 3501 (
    echo fastboot version ^(!ver_str!^) is older than the minimum supported version ^(35.0.1^).
    echo Download the latest version at https://developer.android.com/studio/releases/platform-tools.html and add it to the shell PATH
    call:pakExit
  )
)

echo Available devices:
fastboot devices -l
if %errorlevel% neq 0 call:pakExit

for /f "tokens=2" %%a in ('fastboot getvar product 2^>^&1 ^| find "product:"') do (
  set "product=%%a"
)
if not "%product%" == "frankel" (
  echo Error: this factory image is for frankel, but the name of connected device is %product%
  call:pakExit
)
for /f "tokens=2" %%a in ('fastboot getvar slot-count 2^>^&1 ^| find "slot-count:"') do (
  set "slotcount=%%a"
)
if not "%slotcount%" == "2" (
  echo Error: unexpected value of slot-count variable: expected 2, got %slotcount%
  call:pakExit
)
fastboot flash --slot=other bootloader bootloader-frankel-deepspace-16.4-14451019.img
if %errorlevel% neq 0 call:pakExit

fastboot --set-active=other
if %errorlevel% neq 0 call:pakExit

fastboot reboot-bootloader
if %errorlevel% neq 0 call:pakExit

ping -n 5 127.0.0.1 >nul
fastboot flash --slot=other bootloader bootloader-frankel-deepspace-16.4-14451019.img
if %errorlevel% neq 0 call:pakExit

fastboot --set-active=other
if %errorlevel% neq 0 call:pakExit

fastboot reboot-bootloader
if %errorlevel% neq 0 call:pakExit

ping -n 5 127.0.0.1 >nul
:: size of partition splits depends on this value
for /f "tokens=2" %%a in ('fastboot getvar max-download-size 2^>^&1 ^| find "max-download-size:"') do (
  set "maxdownloadsize=%%a"
)
if not "%maxdownloadsize%" == "0x10000000" (
  echo Error: unexpected value of max-download-size variable: expected 0x10000000, got %maxdownloadsize%
  call:pakExit
)
:: layout of the super partition depends on the current slot, which is hardcoded to slot A
fastboot --set-active=a
if %errorlevel% neq 0 call:pakExit

for /f "tokens=2" %%a in ('fastboot getvar current-slot 2^>^&1 ^| find "current-slot:"') do (
  set "currentslot=%%a"
)
if not "%currentslot%" == "a" (
  echo Error: unexpected value of current-slot variable: expected a, got %currentslot%
  call:pakExit
)
fastboot flash radio radio-frankel-g5400i-250908-251105-b-14386369.img
if %errorlevel% neq 0 call:pakExit

fastboot reboot-bootloader
if %errorlevel% neq 0 call:pakExit

ping -n 5 127.0.0.1 >nul
fastboot erase avb_custom_key
if %errorlevel% neq 0 call:pakExit

fastboot flash avb_custom_key avb_pkmd.bin
if %errorlevel% neq 0 call:pakExit

fastboot oem uart disable
if %errorlevel% neq 0 call:pakExit

fastboot erase dpm_a
if %errorlevel% neq 0 call:pakExit

fastboot erase dpm_b
if %errorlevel% neq 0 call:pakExit

:: this command only checks android-info.txt requirements, it does not perform an update
fastboot --disable-super-optimization --skip-reboot update android-info.zip
if %errorlevel% neq 0 call:pakExit

fastboot snapshot-update cancel
if %errorlevel% neq 0 call:pakExit

fastboot flash boot boot.img
if %errorlevel% neq 0 call:pakExit

fastboot flash init_boot init_boot.img
if %errorlevel% neq 0 call:pakExit

fastboot flash dtbo dtbo.img
if %errorlevel% neq 0 call:pakExit

fastboot flash vendor_kernel_boot vendor_kernel_boot.img
if %errorlevel% neq 0 call:pakExit

fastboot flash pvmfw pvmfw.img
if %errorlevel% neq 0 call:pakExit

fastboot flash vendor_boot vendor_boot.img
if %errorlevel% neq 0 call:pakExit

fastboot flash vbmeta vbmeta.img
if %errorlevel% neq 0 call:pakExit

fastboot erase userdata
if %errorlevel% neq 0 call:pakExit

fastboot erase metadata
if %errorlevel% neq 0 call:pakExit

echo Flashing super, 1/14
fastboot flash super super_1.img
if %errorlevel% neq 0 call:pakExit

echo Flashing super, 2/14
fastboot flash super super_2.img
if %errorlevel% neq 0 call:pakExit

echo Flashing super, 3/14
fastboot flash super super_3.img
if %errorlevel% neq 0 call:pakExit

echo Flashing super, 4/14
fastboot flash super super_4.img
if %errorlevel% neq 0 call:pakExit

echo Flashing super, 5/14
fastboot flash super super_5.img
if %errorlevel% neq 0 call:pakExit

echo Flashing super, 6/14
fastboot flash super super_6.img
if %errorlevel% neq 0 call:pakExit

echo Flashing super, 7/14
fastboot flash super super_7.img
if %errorlevel% neq 0 call:pakExit

echo Flashing super, 8/14
fastboot flash super super_8.img
if %errorlevel% neq 0 call:pakExit

echo Flashing super, 9/14
fastboot flash super super_9.img
if %errorlevel% neq 0 call:pakExit

echo Flashing super, 10/14
fastboot flash super super_10.img
if %errorlevel% neq 0 call:pakExit

echo Flashing super, 11/14
fastboot flash super super_11.img
if %errorlevel% neq 0 call:pakExit

echo Flashing super, 12/14
fastboot flash super super_12.img
if %errorlevel% neq 0 call:pakExit

echo Flashing super, 13/14
fastboot flash super super_13.img
if %errorlevel% neq 0 call:pakExit

echo Flashing super, 14/14
fastboot flash super super_14.img
if %errorlevel% neq 0 call:pakExit

:pakExit
echo Press any key to exit...
pause >nul
exit
