#!/bin/sh

#    SSSSSSSSSSSSSSS  TTTTTTTTTTTTTTTTTTTTTTT      OOOOOOOOO      PPPPPPPPPPPPPPPPP
#  SS:::::::::::::::S T:::::::::::::::::::::T    OO:::::::::OO    P::::::::::::::::P
# S:::::SSSSSS::::::S T:::::::::::::::::::::T  OO:::::::::::::OO  P::::::PPPPPP:::::P
# S:::::S     SSSSSSS T:::::TT:::::::TT:::::T O:::::::OOO:::::::O PP:::::P     P:::::P
# S:::::S             TTTTTT  T:::::T  TTTTTT O::::::O   O::::::O   P::::P     P:::::P
# S:::::S                     T:::::T         O:::::O     O:::::O   P::::P     P:::::P
#  S::::SSSS                  T:::::T         O:::::O     O:::::O   P::::PPPPPP:::::P
#   SS::::::SSSSS             T:::::T         O:::::O     O:::::O   P:::::::::::::PP
#     SSS::::::::SS           T:::::T         O:::::O     O:::::O   P::::PPPPPPPPP
#        SSSSSS::::S          T:::::T         O:::::O     O:::::O   P::::P
#             S:::::S         T:::::T         O:::::O     O:::::O   P::::P
#             S:::::S         T:::::T         O::::::O   O::::::O   P::::P
# SSSSSSS     S:::::S       TT:::::::TT       O:::::::OOO:::::::O PP::::::PP
# S::::::SSSSSS:::::S       T:::::::::T        OO:::::::::::::OO  P::::::::P
# S:::::::::::::::SS        T:::::::::T          OO:::::::::OO    P::::::::P
#  SSSSSSSSSSSSSSS          TTTTTTTTTTT            OOOOOOOOO      PPPPPPPPPP
#
# DO NOT EDIT THIS FILE. THE OFFICIAL GRAPHENEOS INSTALL GUIDE WILL NEVER INSTRUCT YOU
# TO EDIT THIS FILE. IF YOU ARE FOLLOWING A 3RD PARTY GUIDE YOU SHOULD STOP IMMEDIATELY
# AND START OVER AND FOLLOW THE OFFICIAL INSTALLATION PROCESS ON THE OFFICIAL WEBSITE.
# USING THE WEB INSTALLER IS STRONGLY RECOMMENDED https://grapheneos.org/install/web
# THE CLI INSTALLATION PROCESS SHOULD ONLY BE USED BY USERS WITH SPECIFIC NEEDS.

# Copyright 2012 The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

if ! command -v fastboot > /dev/null; then
  echo "fastboot not found"
  echo "Download the latest version at https://developer.android.com/studio/releases/platform-tools.html and add it to the shell PATH"
  exit 1
fi

set -e

FASTBOOT_VERSION_STR=$(fastboot --version | grep "fastboot version " | cut -c18-23)
FASTBOOT_VERSION_NUM=$(echo $FASTBOOT_VERSION_STR | tr -d .)
if ! [ $FASTBOOT_VERSION_NUM -ge 3501 ]; then
  echo "fastboot version ($FASTBOOT_VERSION_STR) is older than the minimum supported version (35.0.1)."
  echo "Download the latest version at https://developer.android.com/studio/releases/platform-tools.html and add it to the shell PATH"
  exit 1
fi

echo Available devices:
fastboot devices -l
product=$(fastboot getvar product 2>&1 | grep "product:" | cut -d ' ' -f 2)
if ! [ $product = "felix" ]; then
  echo Error: this factory image is for felix, but the name of connected device is $product
  exit 1
fi
slotcount=$(fastboot getvar slot-count 2>&1 | grep "slot-count:" | cut -d ' ' -f 2)
if ! [ $slotcount = "2" ]; then
  echo Error: unexpected value of slot-count variable: expected 2, got $slotcount
  exit 1
fi
fastboot flash --slot=other bootloader bootloader-felix-felix-16.4-14097579.img
fastboot --set-active=other
fastboot reboot-bootloader
sleep 5
fastboot flash --slot=other bootloader bootloader-felix-felix-16.4-14097579.img
fastboot --set-active=other
fastboot reboot-bootloader
sleep 5
# size of partition splits depends on this value
maxdownloadsize=$(fastboot getvar max-download-size 2>&1 | grep "max-download-size:" | cut -d ' ' -f 2)
if ! [ $maxdownloadsize = "0xf900000" ]; then
  echo Error: unexpected value of max-download-size variable: expected 0xf900000, got $maxdownloadsize
  exit 1
fi
# layout of the super partition depends on the current slot, which is hardcoded to slot A
fastboot --set-active=a
currentslot=$(fastboot getvar current-slot 2>&1 | grep "current-slot:" | cut -d ' ' -f 2)
if ! [ $currentslot = "a" ]; then
  echo Error: unexpected value of current-slot variable: expected a, got $currentslot
  exit 1
fi
fastboot flash radio radio-felix-g5300q-250909-251024-b-14326967.img
fastboot reboot-bootloader
sleep 5
fastboot erase avb_custom_key
fastboot flash avb_custom_key avb_pkmd.bin
fastboot oem uart disable
fastboot erase fips
fastboot erase dpm_a
fastboot erase dpm_b
# this command only checks android-info.txt requirements, it does not perform an update
fastboot --disable-super-optimization --skip-reboot update android-info.zip
fastboot snapshot-update cancel
fastboot flash boot boot.img
fastboot flash init_boot init_boot.img
fastboot flash dtbo dtbo.img
fastboot flash vendor_kernel_boot vendor_kernel_boot.img
fastboot flash pvmfw pvmfw.img
fastboot flash vendor_boot vendor_boot.img
fastboot flash vbmeta vbmeta.img
fastboot erase userdata
fastboot erase metadata
echo Flashing super, 1/14
fastboot flash super super_1.img
echo Flashing super, 2/14
fastboot flash super super_2.img
echo Flashing super, 3/14
fastboot flash super super_3.img
echo Flashing super, 4/14
fastboot flash super super_4.img
echo Flashing super, 5/14
fastboot flash super super_5.img
echo Flashing super, 6/14
fastboot flash super super_6.img
echo Flashing super, 7/14
fastboot flash super super_7.img
echo Flashing super, 8/14
fastboot flash super super_8.img
echo Flashing super, 9/14
fastboot flash super super_9.img
echo Flashing super, 10/14
fastboot flash super super_10.img
echo Flashing super, 11/14
fastboot flash super super_11.img
echo Flashing super, 12/14
fastboot flash super super_12.img
echo Flashing super, 13/14
fastboot flash super super_13.img
echo Flashing super, 14/14
fastboot flash super super_14.img
